﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.Reflection;
using System.ComponentModel;
using System.Drawing;
using System.Text.RegularExpressions;
using System.Globalization;
using System.Media;

namespace PsgBase
{
    public class psgTextBox : TextBox
    {
        #region Fields / Contructors

        public string initial_value = string.Empty;       
        string valueKey = string.Empty;
        string fieldKey = string.Empty;
        string fieldName = string.Empty;
        string servertablename = string.Empty;
        string fieldType;
        bool notNull = false;      
        int hmn_loop;
        string regEx = string.Empty;
        bool numeric = false;

        public void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // psgEdit
            // 
            this.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.TextChanged += new System.EventHandler(this.psgedit_TextChanged);
            this.Validated += new System.EventHandler(this.psgedit_Validated);
            this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.psgedit_KeyPress);
            this.Enter += new System.EventHandler(this.psgedit_Enter);
            this.Validating += new System.ComponentModel.CancelEventHandler(this.psgedit_Validating);
            this.ResumeLayout(false);

        }

        public psgTextBox()
        {
            InitializeComponent();

            this.DataBindings.DefaultDataSourceUpdateMode = DataSourceUpdateMode.OnPropertyChanged;
        }

        #endregion

        #region Properties

        [Category("PSG")]
        public bool PsgNumeric
        {
            get { return numeric; }
            set { numeric = value; }
        }

        [Category("PSG")]
        public string PsgFieldType
        {
            get { return fieldType; }
            set { fieldType = value; }
        }

        [Category("PSG")]
        public bool PsgNotNull
        {
            get { return notNull; }
            set { notNull = value; }
        }

        [Category("PSG")]
        public string PsgRegEx
        {
            get { return regEx; }
            set { regEx = value; }
        }

        [Category("PSG")]
        public string PsgFieldName
        {
            get { return fieldName; }
            set
            {
                fieldName = value;
            }
        }

        [Category("PSG"), Browsable(false)]
        public string PsgValueKey
        {
            get { return valueKey; }
            set { valueKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return servertablename; }
            set { servertablename = value; }
        }

        #endregion

        private void psgedit_Validating(object sender, CancelEventArgs e)
        {
            try
            {
                if (!Base.bCancelEntity && this.PsgNotNull && string.IsNullOrEmpty(this.Text))
                {
                    Base.psgIntf.ErrorProvider.SetError(this, Base.GetIntl(ConstantsBase.Field_is_required));
                    e.Cancel = true;
                    return;
                }
                else
                    Base.psgIntf.ErrorProvider.SetError(this, string.Empty);

                if (!string.IsNullOrEmpty(this.PsgRegEx) &&
                    !string.IsNullOrEmpty(this.Text) &&
                    !Regex.IsMatch(this.Text, this.PsgRegEx))
                {
                    Base.psgIntf.ErrorProvider.SetError(this, "Invalid value.");
                    e.Cancel = true;
                    return;
                }
                else if (this.PsgNumeric && string.IsNullOrEmpty(this.Text))
                {
                    Base.psgIntf.ErrorProvider.SetError(this, "Invalid value.");
                    e.Cancel = true;
                    return;
                }
                else
                    Base.psgIntf.ErrorProvider.SetError(this, string.Empty);
            }
            finally
            {
                Base.psgIntf.RefreshForm();
            }

            if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                string.IsNullOrEmpty(this.PsgFieldKey) ||
                string.IsNullOrEmpty(this.PsgFieldName) ||
                string.IsNullOrEmpty(this.PsgFieldType))
            {
                MessageBox.Show("PSG properties are not set. ", "Attention!");
                return;
            }

            Intf.cmdResult = PsgMsg.NOK;
            if (psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName)))
            {
                hmn_loop = 0;
                while (Intf.cmdResult != PsgMsg.OK && this.hmn_loop <= 200)
                {
                    Thread.Sleep(30);
                    this.hmn_loop = this.hmn_loop + 1;
                }

                if (Intf.cmdResult != PsgMsg.OK)
                {
                    MessageBox.Show("Check server connectivity and try again!", Base.GetIntl(ConstantsBase.Attention_), MessageBoxButtons.OK);
                    this.Text = this.initial_value;

                    if (e != null)
                        e.Cancel = true;

                    Intf.cmdResult = PsgMsg.OK;
                    return;
                }

                this.initial_value = this.Text;
            }

            View view = ((Base)this.FindForm()).view;
            if (view != null && view is ViewGrid && view.bsEditor != null)
                view.bsEditor.EndEdit();

        }
        public bool psgUpdate(object sender, string _id)
        {
            bool result;

            if (!Utils.StringEqualsUpdate(this.Text, this.initial_value))
            {
                Base.kv = Base.GetParameters(_id, "C");
                Base.value = Base.GetParameters(this.Text.Trim(), fieldType);

                if (Base.value.Length < 130)
                    Base.psgIntf.send_command("UPDATEFIELD#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                               + "'," + Base.kv + ",'" + this.PsgFieldName + "'," + Base.value);
                else
                {
                    string _value = (char)17 + System.Convert.ToBase64String(System.Text.ASCIIEncoding.ASCII.GetBytes(this.Text.Trim())) + (char)17;
                    Base.psgIntf.send_command("UPDATETEXT#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                            + "'," + Base.kv + ",'" + this.PsgFieldName + "'" + _value);
                }

                result = true;
            }
            else
                result = false;

            return result;
        }

        private void psgedit_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == Convert.ToChar(13))
            {
                this.psgedit_Validating(sender, null);

                if (!this.Multiline)
                {
                    SendKeys.Send("{TAB}");
                    e.Handled = true;
                }
            }
        }
        protected override void OnKeyPress(KeyPressEventArgs e)
        {
            base.OnKeyPress(e);

            if (this.PsgNumeric)
            {
                NumberFormatInfo numberFormatInfo = System.Globalization.CultureInfo.CurrentCulture.NumberFormat;
                string decimalSeparator = numberFormatInfo.NumberDecimalSeparator;
                string groupSeparator = numberFormatInfo.NumberGroupSeparator;
                string negativeSign = numberFormatInfo.NegativeSign;

                string keyInput = e.KeyChar.ToString();

                if (Char.IsDigit(e.KeyChar))
                {
                    // Digits are OK
                }
                else if (keyInput.Equals(decimalSeparator) || keyInput.Equals(negativeSign))
                {
                 //Decimal separator is OK
                }
                else if (e.KeyChar == '\b')
                {
                    // Backspace key is OK
                }
                //    else if ((ModifierKeys & (Keys.Control | Keys.Alt)) != 0)
                //    {
                //     // Let the edit control handle control and alt key combinations
                //    }
                //else if (this.allowSpace && e.KeyChar == ' ')
                //{

                //}
                else
                {
                    // Consume this invalid key and beep
                    e.Handled = true;
                    SystemSounds.Beep.Play();
                }
            }
        }
        protected override void OnKeyUp(KeyEventArgs e)
        {
            base.OnKeyUp(e);
            if (string.IsNullOrEmpty(this.Text))
                this.Text = "0";
        }
        void psgedit_Enter(object sender, EventArgs e)
        {
            this.initial_value = this.Text;
        }

        private void psgedit_TextChanged(object sender, EventArgs e)
        {
            if (this.DesignMode)
                return;

            if (this.PsgNotNull && string.IsNullOrEmpty(this.Text))
                Base.psgIntf.ErrorProvider.SetError(this, Base.GetIntl(ConstantsBase.Field_is_required));
            else
                Base.psgIntf.ErrorProvider.SetError(this, string.Empty);
        }
        private void psgedit_Validated(object sender, EventArgs e)
        {
            //if (!string.IsNullOrEmpty(this.PsgNotNull) &&
            //     string.IsNullOrEmpty(this.Text))
            //{
            //    Base.baseIntf.ErrorProvider.SetError(this, this.PsgNotNull);
            //    return;
            //}
            //else
            //    Base.baseIntf.ErrorProvider.SetError(this, string.Empty);

            //Base.baseIntf.RefreshForm();
        }
    }
}
